/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block;

import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SinkBlock
extends Block {
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final Map<Direction, VoxelShape> TOP_SHAPES = new HashMap<Direction, VoxelShape>();
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();

    public SinkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.75, (double)0.625, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.125, (double)0.75, (double)0.375, (double)0.3125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.3125, (double)0.5, (double)0.5625, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.25, (double)0.4375, (double)0.625, (double)0.3125, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0625, (double)0.8125, (double)0.5625, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.375, (double)0.625, (double)0.5625, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.1875, (double)0.8125, (double)0.4375, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.1875, (double)0.1875, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.75, (double)0.1875, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return TOP_SHAPES.get(facing);
        }
        return BOTTOM_SHAPES.get(facing);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_ || state.m_61143_(HALF) != DoubleBlockHalf.LOWER) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_() && !((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!(item != Items.f_42447_ && item != Items.f_42590_ || ((Boolean)state.m_61143_((Property)FILLED)).booleanValue())) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                if (item == Items.f_42447_) {
                    itemStack.m_41774_(1);
                    player.m_36356_(new ItemStack((ItemLike)Items.f_42446_));
                } else {
                    itemStack.m_41774_(1);
                    player.m_36356_(new ItemStack((ItemLike)Items.f_42590_));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if ((item == Items.f_42446_ || item == Items.f_42590_) && ((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)), 3);
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                if (item == Items.f_42446_) {
                    itemStack.m_41774_(1);
                    player.m_36356_(new ItemStack((ItemLike)Items.f_42447_));
                } else {
                    itemStack.m_41774_(1);
                    player.m_36356_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FILLED, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        return context.m_43725_().m_8055_(blockPos.m_7494_()).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()) : null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockPos = pos.m_7495_();
            BlockState blockState = world.m_8055_(blockPos);
            return blockState.m_60713_((Block)this) && blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.m_7898_(state, world, pos);
    }

    public static void placeAt(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, int i) {
        BlockPos blockPos2 = blockPos.m_7494_();
        levelAccessor.m_7731_(blockPos, SinkBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockPos, (BlockState)blockState.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)), i);
        levelAccessor.m_7731_(blockPos2, SinkBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockPos2, (BlockState)blockState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), i);
    }

    private static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(blockPos))) : blockState;
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState2 = level.m_8055_(blockPos2 = blockPos.m_7495_())).m_60713_(blockState.m_60734_()) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = blockState2.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockPos2, blockState3, 35);
            level.m_5898_(player, 2001, blockPos2, Block.m_49956_((BlockState)blockState2));
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos blockPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60734_() == this && blockState.m_61143_(HALF) != half) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
            if (!world.f_46443_ && !player.m_7500_()) {
                SinkBlock.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                SinkBlock.m_49881_((BlockState)blockState, (Level)world, (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, Blocks.f_50016_.m_49966_(), blockEntity, itemStack);
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockPos blockPos2 = blockPos.m_7494_();
            BlockState blockState2 = level.m_8055_(blockPos2);
            if (blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                level.m_46961_(blockPos2, true);
            }
        } else {
            BlockPos blockPos1 = blockPos.m_7495_();
            BlockState blockState1 = level.m_8055_(blockPos1);
            if (blockState1.m_60713_((Block)this) && blockState1.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                level.m_46961_(blockPos1, true);
            }
        }
    }

    public long m_7799_(BlockState blockState, BlockPos blockPos) {
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)blockPos.m_6625_(blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)blockPos.m_123343_());
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource randomSource) {
        float chance = randomSource.m_188501_();
        if (chance < 0.1f) {
            SinkBlock.spawnDripParticle(world, pos, state);
        }
    }

    public static void spawnDripParticle(Level level, BlockPos blockPos, BlockState blockState) {
        Vec3 vec3 = blockState.m_60824_((BlockGetter)level, blockPos);
        double d = 0.0625;
        double e = (double)blockPos.m_123341_() + 0.5 + vec3.f_82479_;
        double f = (double)((float)((double)blockPos.m_123342_() + 0.9) - 0.6875f) - d;
        double g = (double)blockPos.m_123343_() + 0.5 + vec3.f_82481_;
        SimpleParticleType particleOptions = ParticleTypes.f_123803_;
        level.m_7106_((ParticleOptions)particleOptions, e, f, g, 0.0, 0.0, 0.0);
    }

    static {
        Supplier<VoxelShape> topShapeSupplier = SinkBlock::makeTopShape;
        Supplier<VoxelShape> bottomShapeSupplier = SinkBlock::makeBottomShape;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, topShapeSupplier.get()));
            BOTTOM_SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, bottomShapeSupplier.get()));
        }
    }
}

